{
	"assegai":{
		"type":"item",
		"age":"woodenAge",
		"category":"weapon",
		"picture":{"file":"assegai.atf"},
		"name":{"EN":"assegai",
				"FR":"sagaie"},
		"description":{"EN":"Assegais are primitive throwing weapon manufactured from wood.",
					   "FR":"Les sagaies sont des armes de lancé primitives et fabriquée en bois."},
		"bonus":{"attack":{"throwingWeapons":0.2}},
		"attackTime":1.5, "range":112, "missile":"assegaiMissile",
		"damage":["missile", "crushing"],
		"attack":{
			"costItem":{"assegai":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.5}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no assegai"]},
				"FR":{"D":["Je n'ai pas de sagaie"]}},
		"lack":{"EN":{"D":["I do not have enough assegais"]},
				"FR":{"D":["Je n'ai pas assez de sagaies"]}},
		"out":{"EN":{"D":["I have used up my assegai"]},
			   "FR":{"D":["Je n'ai plus de sagaie"]}},
		"full":{"EN":{"D":["I have too many assegais."]},
				"FR":{"D":["J'ai le maximum de sagaies."]}},
		"produce":[{
				"workshop":"huntingCamp",
				"no":2.5,
				"time":0.5,
				"gainItem":{"assegai":5},
				"bonusSkill":"hunting",
				"costRessource":{"wood":1},
				"costPrimaryCharacteristic":{"stamina":1},
				"xpSecondaryCharacteristic":{"strength":1},
				"xpSkill":{"hunting":1},
				"repeat":true,
				"quantity":-1
		}]
	},
	"backMissileLauncher":{
		"type":"item",
		"age":"steamAge",
		"category":"back",
		"picture":{"file":"backMissileLauncher.atf"},
		"name":{"EN":"back missile launcher",
				"FR":"lance-missiles dorsale"},
		"description":{"EN":"The back missile launcher allow to fire micro missiles without hands. It need micro missiles as ammo.",
					   "FR":"Le lance-missiles dorsale permet de tirer des missiles sans les mains. Il nécessite d'employer des micro missiles comme munitions."},
		"bonus":{"attack":{"firearms":4}},
		"damage":["missile", "explosion"],
		"attackTime":12, "range":500, "missile":"microMissile",
		"attacks":[{"range":500, "damage":["missile", "explosion"], "missile":"microMissile", "fixedAngle":-1.57, "attackDX":10, "selfGuided":0.125,
						"special":{"area":{"attack":{"firearms":1.05}, "range":32, "effect":"miniExplosion"}}},
				   {"range":500, "damage":["missile", "explosion"], "missile":"microMissile", "fixedAngle":-1.57, "attackDX":-10, "selfGuided":0.125,
						"special":{"area":{"attack":{"firearms":1.05}, "range":32, "effect":"miniExplosion"}}}],
		"attack":{
			"costItem":{"microRockets":2}
		},
		"sound":"soundRocket",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.125},
			"xpSkill":{"firearms":0.125}
		},
		"equip":true
	},
	"boomerang":{
		"type":"item",
		"age":"stoneAge",
		"category":"weapon",
		"picture":{"file":"boomerang.atf"},
		"name":{"EN":"boomerang",
				"FR":"boomerang"},
		"description":{"EN":"The boomerang is a throwingweapon that launched back in the hand of its thrower if it misses its target.",
					   "FR":"Le boomerang est une arme de lancé qui revient dans la main de son lanceur si elle manque sa cible."},
		"bonus":{"attack":{"throwingWeapons":0.4}},
		"damage":["missile", "crushing"],
		"attackTime":1.5, "range":200, "missile":"boomerangMissile",
		"special":{"back":{"boomerang":1}},
		"attack":{
			"costItem":{"boomerang":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.5}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no boomerang"]},
				"FR":{"D":["Je n'ai pas de boomerang"]}},
		"lack":{"EN":{"D":["I do not have enough boomerangs"]},
				"FR":{"D":["Je n'ai pas assez de boomerangs"]}},
		"out":{"EN":{"D":["I have used up my boomerang"]},
			   "FR":{"D":["Je n'ai plus de boomerang"]}},
		"full":{"EN":{"D":["I have too many boomerangs"]},
				"FR":{"D":["J'ai le maximum de boomerangs"]}}
	},
	"bow":{
		"type":"item",
		"age":"ironAge",
		"category":"weapon",
		"picture":{"file":"bow.atf"},
		"name":{"EN":"bow",
				"FR":"arc"},
		"description":{"EN":"The bow is a miedeval range and two handed weapon manufactured from wood.",
					   "FR":"L'arc est une arme médiévale de tir, à deux mains et fabriquée en bois."},
		"bonus":{"attack":{"bows":1.2}},
		"damage":["missile", "piercing"],
		"attackTime":2, "range":300, "missile":"arrow",
		"attack":{
			"costItem":{"arrows":1}
		},
		"sound":"soundBow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"bows":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":5,
				"gainItem":{"longBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":10},
				"costPrimaryCharacteristic":{"stamina":10},
				"xpSecondaryCharacteristic":{"address":10},
				"xpSkill":{"bowsCrafting":10},
				"quantity":-10
			},{
				"workshop":"archeryCamp",
				"time":10,
				"gainItem":{"compositeBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":20},
				"costPrimaryCharacteristic":{"stamina":20},
				"xpSecondaryCharacteristic":{"address":20},
				"xpSkill":{"bowsCrafting":20},
				"quantity":-20
			},{
				"workshop":"archeryCamp",
				"time":15,
				"gainItem":{"compoundBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":20, "steel":2},
				"costPrimaryCharacteristic":{"stamina":30},
				"xpSecondaryCharacteristic":{"address":30},
				"xpSkill":{"bowsCrafting":30},
				"quantity":-30
		}]
	},
	"compositeBow":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"compositeBow.atf"},
		"name":{"EN":"composite bow",
				"FR":"arc composite"},
		"description":{"EN":"The composite bow is a powerful range and two handed weapon manufactured from wood.",
					   "FR":"L'arc composite est une puissante arme de tir, à deux mains et fabriquée en bois."},
		"bonus":{"attack":{"bows":2}},
		"damage":["missile", "piercing"],
		"attackTime":2, "range":400, "missile":"arrow",
		"attack":{
			"costItem":{"arrows":1}
		},
		"sound":"soundBow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"bows":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":5,
				"gainItem":{"compoundBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"steel":2},
				"costPrimaryCharacteristic":{"stamina":10},
				"xpSecondaryCharacteristic":{"address":10},
				"xpSkill":{"bowsCrafting":10},
				"quantity":-10
		}]
	},
	"compoundBow":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"compoundBow.atf"},
		"name":{"EN":"compound bow",
				"FR":"arc à poulies"},
		"description":{"EN":"The compoundbow is a modern range and two handed weapon manufactured from wood and steel.",
					   "FR":"L'arc à poulies est une arme de tir moderne, à deux mains et fabriquée en bois et en acier."},
		"bonus":{"attack":{"bows":2.26}},
		"damage":["missile", "piercing"],
		"attackTime":2, "range":450, "missile":"arrow",
		"attack":{
			"costItem":{"arrows":1}
		},
		"sound":"soundBow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"bows":1}
		},
		"equip":true,
		"produce":[{
				"workshop":"archeryCamp",
				"no":11,
				"time":30,
				"gainItem":{"compoundBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":50, "steel":2},
				"costPrimaryCharacteristic":{"stamina":60},
				"xpSecondaryCharacteristic":{"address":60},
				"xpSkill":{"bowsCrafting":60},
				"quantity":-60
		}]
	},
	"crossbow":{
		"type":"item",
		"age":"ironAge",
		"category":"weapon",
		"picture":{"file":"crossbow.atf"},
		"name":{"EN":"crossbow",
				"FR":"arbalète"},
		"description":{"EN":"The crossbow is a miedeval range and two handed weapon manufactured from cast iron.",
					   "FR":"L'arbalète est une arme médiévale de tir, à deux mains et fabriquée en métal."},
		"bonus":{"attack":{"shootingWeapons":1.5}},
		"damage":["missile", "piercing"],
		"attackTime":2.5, "range":300, "missile":"bolt",
		"attack":{
			"costItem":{"bolts":1}
		},
		"sound":"soundCrossbow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"shootingWeapons":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":3,
				"gainItem":{"heavyCrossbow":1},
				"bonusTimeSkill":"crossbowsForging",
				"costRessource":{"castIron":2},
				"costPrimaryCharacteristic":{"stamina":6},
				"xpSecondaryCharacteristic":{"address":6},
				"xpSkill":{"crossbowsForging":6},
				"quantity":-6
			},{
				"workshop":"archeryCamp",
				"time":6,
				"gainItem":{"repeatingCrossbow":1},
				"bonusTimeSkill":"crossbowsForging",
				"costRessource":{"castIron":4},
				"costPrimaryCharacteristic":{"stamina":12},
				"xpSecondaryCharacteristic":{"address":12},
				"xpSkill":{"crossbowsForging":12},
				"quantity":-12
		}]
	},
	"diskThrower":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"diskThrower.atf"},
		"name":{"EN":"disk thrower",
				"FR":"lance disques"},
		"description":{"EN":"The disk thrower is a two handed crossbow which project steel disks.",
					   "FR":"Le lance-diques est une arbalète à 2 mains qui projette des disques d'acier."},
		"bonus":{"attack":{"shootingWeapons":3.25}},
		"damage":["missile", "slashing"],
		"attackTime":2.5, "range":450, "missile":"diskMissile", "special":{"selfGuided":0.05},
		"attack":{
			"costItem":{"disks":1}
		},
		"sound":"soundCrossbow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"shootingWeapons":1}
		},
		"equip":true,
		"produce":[{
				"workshop":"archeryCamp",
				"no":13,
				"time":15,
				"gainItem":{"diskThrower":1},
				"bonusTimeSkill":"crossbowsForging",
				"costRessource":{"steel":10},
				"costPrimaryCharacteristic":{"stamina":30},
				"xpSecondaryCharacteristic":{"strength":30},
				"xpSkill":{"firearmsForging":30},
				"quantity":-10
		}]
	},
	"gunblade":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"gunblade.atf"},
		"name":{"EN":"gunblade",
				"FR":"gunblade"},
		"description":{"EN":"The gunblade is both a blade and a firearm.",
					   "FR":"La gunblade est un mixte entre une épée et une arme à feu."},
		"bonus":{"attack":{"edgedWeapons":1}},
		"damage":["closeCombat", "slashing"],
		"attackTime":1,
		"anim":"shoot",
		"effect":"blade",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"strength":0.25},
			"xpSkill":{"edgedWeapons":0.25}
		},
		"addItems":[{
			"id":"gunblade",
			"bonus":{"attack":{"firearms":1.5}},
			"damage":["missile", "piercing"],
			"attackTime":3, "range":350, "missile":"cartridge",
			"attack":{
				"costItem":{"cartridges":1}
			},
			"sound":"soundGun",
			"anim":"shoot",
			"xpAttack":{
				"xpSecondaryCharacteristic":{"address":0.25},
				"xpSkill":{"firearms":0.25}
			}}]
		,
		"equip":true,
		"oneHand":true
	},
	"handgun":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"handgun.atf"},
		"name":{"EN":"handgun",
				"FR":"pistolet"},
		"description":{"EN":"The handgun is a fire and one handed weapon manufactured from cast iron.",
					   "FR":"Le pistolet est une arme à feu, à une main et fabriquée en fonte."},
		"bonus":{"attack":{"firearms":1.5}},
		"damage":["missile", "piercing"],
		"attackTime":3, "range":350, "missile":"cartridge",
		"attack":{
			"costItem":{"cartridges":1}
		},
		"sound":"soundGun",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"firearms":0.5}
		},
		"equip":true,
		"oneHand":true,
		"upgrade":[{
				"workshop":"arsenal",
				"time":6,
				"gainItem":{"machinePistol":1},
				"bonusTimeSkill":"firearmsForging",
				"costRessource":{"steel":4},
				"costPrimaryCharacteristic":{"stamina":12},
				"xpSecondaryCharacteristic":{"strength":12},
				"xpSkill":{"firearmsForging":12},
				"quantity":-4
			}]
	},
	"handGrenade":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"handGrenade.atf"},
		"name":{"EN":"hand grenade",
				"FR":"grenade à main"},
		"description":{"EN":"Hand grenades are explosive throwing weapon manufactured with sulfur and steel.",
					   "FR":"Les grenades à main sont des armes de lancé explosives et fabriquées avec du soufre et de l'acier."},
		"bonus":{"attack":{"throwingWeapons":3.4, "firearms":3.4}},
		"damage":["missile", "explosion"],
		"attackTime":4, "range":200, "missile":"handGrenadeMissile",
		"special":{"endingAnim":"canonExplosion", "area":{"attack":{"throwingWeapons":1.7, "firearms":1.7}, "range":32, "effect":"miniExplosion"}},
		"attack":{
			"costItem":{"handGrenade":1}
		},
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.25, "firearms":0.25}
		},
		"sound":"soundThrow",
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no hand grenade"]},
				"FR":{"D":["Je n'ai pas de grenade à main"]}},
		"lack":{"EN":{"D":["I do not have enough hand grenades"]},
				"FR":{"D":["Je n'ai pas assez de boomerangs"]}},
		"out":{"EN":{"D":["I have used up my hand grenade"]},
			   "FR":{"D":["Je n'ai plus de grenade à main"]}},
		"full":{"EN":{"D":["I have too many hand grenades"]},
				"FR":{"D":["J'ai le maximum de grenades à main"]}}
	},
	"heavyCrossbow":{
		"type":"item",
		"age":"etherAge",
		"category":"weapon",
		"picture":{"file":"heavyCrossbow.atf"},
		"name":{"EN":"heavy crossbow",
				"FR":"arbalète lourde"},
		"description":{"EN":"The heavy crossbow is a miedeval range and two handed weapon manufactured from cast iron.",
					   "FR":"L'arbalète lourde est une arme médiévale de tir, à deux mains et fabriquée en métal."},
		"bonus":{"attack":{"shootingWeapons":2}},
		"damage":["missile", "piercing"],
		"attackTime":2.5, "range":350, "missile":"bolt",
		"attack":{
			"costItem":{"bolts":1}
		},
		"sound":"soundCrossbow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"shootingWeapons":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":3,
				"gainItem":{"repeatingCrossbow":1},
				"bonusTimeSkill":"crossbowsForging",
				"costRessource":{"castIron":2},
				"costPrimaryCharacteristic":{"stamina":6},
				"xpSecondaryCharacteristic":{"address":6},
				"xpSkill":{"crossbowsForging":6},
				"quantity":-6
		}]
	},
	"javelin":{
		"type":"item",
		"age":"etherAge",
		"category":"weapon",
		"picture":{"file":"javelin.atf"},
		"name":{"EN":"javelin",
				"FR":"javelot"},
		"description":{"EN":"Javelins are medieval throwing weapon manufactured from wood and iron.",
					   "FR":"Les javelots sont des armes de lancé médiévale et fabriquées en bois et en fonte."},
		"bonus":{"attack":{"throwingWeapons":0.58}},
		"damage":["missile", "piercing"],
		"attackTime":1.5, "range":300, "missile":"javelinMissile",
		"attack":{
			"costItem":{"javelin":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.5}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no javelin"]},
				"FR":{"D":["Je n'ai pas de javelot"]}},
		"lack":{"EN":{"D":["I do not have enough javelins"]},
				"FR":{"D":["Je n'ai pas assez de javelots"]}},
		"out":{"EN":{"D":["I have used up my javelin"]},
			   "FR":{"D":["Je n'ai plus de javelot"]}},
		"full":{"EN":{"D":["I have too many javelins."]},
				"FR":{"D":["J'ai le maximum de javelots."]}},
		"produce":[{
				"workshop":"archeryCamp",
				"no":6,
				"time":2,
				"gainItem":{"javelin":10},
				"bonusSkill":"hunting",
				"costRessource":{"castIron":1, "wood":1},
				"costPrimaryCharacteristic":{"stamina":4},
				"xpSecondaryCharacteristic":{"strength":4},
				"xpSkill":{"weaponsForging":4},
				"repeat":true,
				"quantity":-4
		}]
	},
	"longBow":{
		"type":"item",
		"age":"etherAge",
		"category":"weapon",
		"picture":{"file":"longBow.atf"},
		"name":{"EN":"long bow",
				"FR":"arc long"},
		"description":{"EN":"The long bow is a powerful range and two handed weapon manufactured from wood.",
					   "FR":"L'arc long est une puissante arme de tir, à deux mains et fabriquée en bois."},
		"bonus":{"attack":{"bows":1.6}},
		"damage":["missile", "piercing"],
		"attackTime":2, "range":350, "missile":"arrow",
		"attack":{
			"costItem":{"arrows":1}
		},
		"sound":"soundBow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"bows":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":5,
				"gainItem":{"compositeBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":10},
				"costPrimaryCharacteristic":{"stamina":10},
				"xpSecondaryCharacteristic":{"address":10},
				"xpSkill":{"bowsCrafting":10},
				"quantity":-10
			},{
				"workshop":"archeryCamp",
				"time":10,
				"gainItem":{"compoundBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":10, "steel":2},
				"costPrimaryCharacteristic":{"stamina":20},
				"xpSecondaryCharacteristic":{"address":20},
				"xpSkill":{"bowsCrafting":20},
				"quantity":-20
		}]
	},
	"machinePistol":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"machinePistol.atf"},
		"name":{"EN":"machine pistol",
				"FR":"pistolet mitrailleur"},
		"description":{"EN":"The machine pistol is a faster fire and one handed weapon manufactured from steel.",
					   "FR":"Le pistolet mitrailleur est une arme à feu rapide, à une main et fabriquée en acier."},
		"bonus":{"attack":{"firearms":0.68}},
		"damage":["missile", "piercing"],
		"attackTime":3, "range":400, "missile":"cartridge",
		"attacks":[{"range":400, "missile":"cartridge"},
				   {"attackDelay":0.1, "range":400, "missile":"cartridge"},
				   {"attackDelay":0.2, "range":400, "missile":"cartridge"}],
		"attack":{
			"costItem":{"cartridges":3}
		},
		"sound":"soundGun",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"firearms":0.5}
		},
		"equip":true,
		"oneHand":true
	},
	"missileLauncher":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"missileLauncher.atf"},
		"name":{"EN":"missile launcher",
				"FR":"lance-missiles"},
		"description":{"EN":"The missile launcher cannon is a heavy firearm and one handed weapon manufactured from steel.",
					   "FR":"Le lance-missiles est une arme à feu lourde, à une main et fabriquée en acier."},
		"bonus":{"attack":{"firearms":12}},
		"damage":["missile", "explosion"],
		"attackTime":9.7, "range":500, "missile":"bigMissile", "special":{"selfGuided":0.125},
		"attack":{
			"costItem":{"rockets":1}
		},
		"sound":"soundRocket",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"firearms":0.5}
		},
		"equip":true,
		"oneHand":true
	},
	"rifle":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"rifle.atf"},
		"name":{"EN":"rifle",
				"FR":"fusil"},
		"description":{"EN":"The rifle is a firearm and two handed weapon manufactured from cast iron.",
					   "FR":"Le fusil est une arme à feu, à deux mains et fabriquée en fonte."},
		"bonus":{"attack":{"firearms":3}},
		"damage":["missile", "piercing"],
		"attackTime":3, "range":400, "missile":"cartridge",
		"attack":{
			"costItem":{"cartridges":1}
		},
		"sound":"soundGun",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"firearms":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"arsenal",
				"time":15,
				"gainItem":{"sniperRifle":1},
				"bonusTimeSkill":"firearmsForging",
				"costRessource":{"steel":10},
				"costPrimaryCharacteristic":{"stamina":30},
				"xpSecondaryCharacteristic":{"strength":30},
				"xpSkill":{"firearmsForging":30},
				"quantity":-10
		}]
	},
	"shortBow":{
		"type":"item",
		"age":"stoneAge",
		"category":"weapon",
		"picture":{"file":"shortBow.atf"},
		"name":{"EN":"short bow",
				"FR":"arc court"},
		"description":{"EN":"The short bow is a primitive range and two handed weapon manufactured from wood.",
					   "FR":"L'arc court est une arme primitive de tir, à deux mains et fabriquée en bois."},
		"bonus":{"attack":{"bows":0.8}},
		"damage":["missile", "piercing"],
		"attackTime":2, "range":250, "missile":"arrow",
		"attack":{
			"costItem":{"arrows":1}
		},
		"sound":"soundBow",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"bows":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"archeryCamp",
				"time":5,
				"gainItem":{"bow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":10},
				"costPrimaryCharacteristic":{"stamina":10},
				"xpSecondaryCharacteristic":{"address":10},
				"xpSkill":{"bowsCrafting":10},
				"quantity":-10
			},{
				"workshop":"archeryCamp",
				"time":10,
				"gainItem":{"longBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":20},
				"costPrimaryCharacteristic":{"stamina":20},
				"xpSecondaryCharacteristic":{"address":20},
				"xpSkill":{"bowsCrafting":20},
				"quantity":-20
			},{
				"workshop":"archeryCamp",
				"time":15,
				"gainItem":{"compositeBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":30},
				"costPrimaryCharacteristic":{"stamina":30},
				"xpSecondaryCharacteristic":{"address":30},
				"xpSkill":{"bowsCrafting":30},
				"quantity":-30
			},{
				"workshop":"archeryCamp",
				"time":20,
				"gainItem":{"compoundBow":1},
				"bonusTimeSkill":"bowsCrafting",
				"costRessource":{"wood":30, "steel":2},
				"costPrimaryCharacteristic":{"stamina":40},
				"xpSecondaryCharacteristic":{"address":40},
				"xpSkill":{"bowsCrafting":40},
				"quantity":-40
		}]
	},
	"shoulderCannon":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"shoulderCannon.atf"},
		"name":{"EN":"shoulder cannon",
				"FR":"canon d'épaule"},
		"description":{"EN":"The shoulder cannon is a heavy firearm and two handed weapon manufactured from cast iron.",
					   "FR":"Le canon d'épaule est une arme à feu lourde, à deux mains et fabriquée en fonte."},
		"bonus":{"attack":{"firearms":12}},
		"damage":["missile", "explosion"],
		"attackTime":12, "range":500, "missile":"cannonBall", "special":{"pierce":true},
		"attack":{
			"costItem":{"cannonBalls":1}
		},
		"sound":"soundCannon",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"firearms":1}
		},
		"equip":true,
		"upgrade":[{
				"workshop":"arsenal",
				"time":27,
				"gainItem":{"missileLauncher":1},
				"bonusTimeSkill":"firearmsForging",
				"costRessource":{"steel":18},
				"costPrimaryCharacteristic":{"stamina":54},
				"xpSecondaryCharacteristic":{"strength":54},
				"xpSkill":{"firearmsForging":54},
				"quantity":-18
		}]
	},
	"sniperRifle":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"sniperRifle.atf"},
		"name":{"EN":"sniper rifle",
				"FR":"fusil de sniper"},
		"description":{"EN":"The sniper rifle is a firearm with long-range.",
					   "FR":"Le fusil sniper est une arme à feu à longue portée."},
		"bonus":{"attack":{"firearms":3.4}},
		"damage":["missile", "piercing"],
		"attackTime":4.5, "range":675, "missile":"cartridge",
		"attack":{
			"costItem":{"cartridges":1}
		},
		"sound":"soundGun",
		"anim":"shoot",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":1},
			"xpSkill":{"firearms":1}
		},
		"equip":true
	},
	"sphericalGrenade":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"sphericalGrenade.atf"},
		"name":{"EN":"spherical grenade",
				"FR":"grenade sphérique"},
		"description":{"EN":"Spherical grenades are explosive throwing weapon manufactured with sulfur and cast iron.",
					   "FR":"Les grenades sphériques sont des armes de lancé explosives et fabriquées avec du soufre et des lingots de fonte."},
		"bonus":{"attack":{"throwingWeapons":3, "firearms":3}},
		"damage":["missile", "explosion"],
		"attackTime":4, "range":150, "missile":"sphericalGrenadeMissile",
		"special":{"endingAnim":"canonExplosion", "area":{"attack":{"throwingWeapons":1.5, "firearms":1.5}, "range":32, "effect":"miniExplosion"}},
		"attack":{
			"costItem":{"sphericalGrenade":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.25, "firearms":0.25}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no spherical grenade"]},
				"FR":{"D":["Je n'ai pas de grenade sphérique"]}},
		"lack":{"EN":{"D":["I do not have enough spherical grenades"]},
				"FR":{"D":["Je n'ai pas assez de sphériques"]}},
		"out":{"EN":{"D":["I have used up my spherical sphérique"]},
			   "FR":{"D":["Je n'ai plus de grenade à main"]}},
		"full":{"EN":{"D":["I have too many spherical grenades"]},
				"FR":{"D":["J'ai le maximum de grenades à sphériques"]}}
	},
	"steelBoomerang":{
		"type":"item",
		"age":"steamAge",
		"category":"weapon",
		"picture":{"file":"steelBoomerang.atf"},
		"name":{"EN":"steel boomerang",
				"FR":"boomerang d'acier"},
		"description":{"EN":"The steel boomerang is a throwingweapon that launched back in the hand of its thrower if it misses its target.",
					   "FR":"Le boomerang d'acier est une arme de lancé qui revient dans la main de son lanceur si elle manque sa cible."},
		"bonus":{"attack":{"throwingWeapons":0.75}},
		"damage":["missile", "slashing"],
		"attackTime":1.5, "range":350, "missile":"steelBoomerangMissile",
		"special":{"back":{"steelBoomerang":1}},
		"attack":{
			"costItem":{"steelBoomerang":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.5}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no steel boomerang"]},
				"FR":{"D":["Je n'ai pas de boomerang d'acier"]}},
		"lack":{"EN":{"D":["I do not have enough steel boomerangs"]},
				"FR":{"D":["Je n'ai pas assez de boomerangs d'acier"]}},
		"out":{"EN":{"D":["I have used up my steel boomerang"]},
			   "FR":{"D":["Je n'ai plus de boomerang d'acier"]}},
		"full":{"EN":{"D":["I have too many steel boomerangs"]},
				"FR":{"D":["J'ai le maximum de boomerangs d'acier"]}}
	},
	"stoneJavelin":{
		"type":"item",
		"age":"stoneAge",
		"category":"weapon",
		"picture":{"file":"stoneJavelin.atf"},
		"name":{"EN":"stone javelin",
				"FR":"javelot de pierre"},
		"description":{"EN":"Stone javelins are rudimentary throwing weapon manufactured from wood and stone.",
					   "FR":"Les javelots de pierre sont des armes de lancé rudimentaires et fabriquées en bois et en pierre."},
		"bonus":{"attack":{"throwingWeapons":0.4}},
		"damage":["missile", "piercing"],
		"attackTime":1.5, "range":200, "missile":"stoneJavelinMissile",
		"attack":{
			"costItem":{"stoneJavelin":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.5}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no stone javelin"]},
				"FR":{"D":["Je n'ai pas de javelot de pierre"]}},
		"lack":{"EN":{"D":["I do not have enough stone javelins"]},
				"FR":{"D":["Je n'ai pas assez de javelots de pierre"]}},
		"out":{"EN":{"D":["I have used up my stone javelin"]},
			   "FR":{"D":["Je n'ai plus de javelot de pierre"]}},
		"full":{"EN":{"D":["I have too many stone javelins."]},
				"FR":{"D":["J'ai le maximum de javelots de pierre."]}}
	},
	"throwingKnife":{
		"type":"item",
		"age":"ironAge",
		"category":"weapon",
		"picture":{"file":"throwingKnife.atf"},
		"name":{"EN":"throwing knife",
				"FR":"couteau de lancer"},
		"description":{"EN":"Throwing knives are throwing weapon manufactured from cast iron.",
					   "FR":"Les couteaux de lancer sont des armes de lancé fabriquées avec des lingots de fonte."},
		"bonus":{"attack":{"throwingWeapons":0.3, "lightWeapons":0.3}},
		"damage":["missile", "piercing"],
		"attackTime":1.5, "range":188, "missile":"throwingKnifeMissile",
		"attack":{
			"costItem":{"throwingKnife":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.5},
			"xpSkill":{"throwingWeapons":0.25, "lightWeapons":0.25}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no throwing knife"]},
				"FR":{"D":["Je n'ai pas de couteau de lancer"]}},
		"lack":{"EN":{"D":["I do not have enough throwing knives"]},
				"FR":{"D":["Je n'ai pas assez de couteaux de lancer"]}},
		"out":{"EN":{"D":["I have used up my throwing knives"]},
			   "FR":{"D":["Je n'ai plus de couteaux de lancer"]}},
		"full":{"EN":{"D":["I have too many throwing knives."]},
				"FR":{"D":["J'ai le maximum de couteaux de lancer"]}},
		"produce":[{
				"workshop":"archeryCamp",
				"no":4.5,
				"time":1.5,
				"gainItem":{"throwingKnife":10},
				"bonusSkill":"hunting",
				"costRessource":{"castIron":1},
				"costPrimaryCharacteristic":{"stamina":3},
				"xpSecondaryCharacteristic":{"strength":3},
				"xpSkill":{"weaponsForging":3},
				"repeat":true,
				"quantity":-3
		}]
	},
	"throwingAxe":{
		"type":"item",
		"age":"goldenAge",
		"category":"weapon",
		"picture":{"file":"throwingAxe.atf"},
		"name":{"EN":"throwing axe",
				"FR":"hache de lancer"},
		"description":{"EN":"Throwing axes are throwing weapon manufactured from cast iron.",
					   "FR":"Les haches de lancer sont des armes de lancé fabriquées avec des lingots de fonte."},
		"bonus":{"attack":{"throwingWeapons":0.5, "axes":0.5}},
		"damage":["missile", "slashing"],
		"attackTime":2, "range":225, "missile":"throwingAxeMissile",
		"attack":{
			"costItem":{"throwingAxe":1}
		},
		"sound":"soundThrow",
		"xpAttack":{
			"xpSecondaryCharacteristic":{"address":0.25, "strength":0.25},
			"xpSkill":{"throwingWeapons":0.25, "axes":0.25}
		},
		"equip":true,
		"oneHand":true,
		"maxQuantity":{"throwingWeapons":1},
		"zero":{"EN":{"D":["I have no throwing axe"]},
				"FR":{"D":["Je n'ai pas de haches de lancer"]}},
		"lack":{"EN":{"D":["I do not have enough throwing axes"]},
				"FR":{"D":["Je n'ai pas assez de haches de lancer"]}},
		"out":{"EN":{"D":["I have used up my throwing axes"]},
			   "FR":{"D":["Je n'ai plus de haches de lancer"]}},
		"full":{"EN":{"D":["I have too many throwing axes"]},
				"FR":{"D":["J'ai le maximum de haches de lancer"]}},
		"produce":[{
				"workshop":"archeryCamp",
				"no":10,
				"time":4.5,
				"gainItem":{"throwingAxe":20},
				"bonusSkill":"hunting",
				"costRessource":{"castIron":3},
				"costPrimaryCharacteristic":{"stamina":9},
				"xpSecondaryCharacteristic":{"strength":9},
				"xpSkill":{"weaponsForging":9},
				"repeat":true,
				"quantity":-9
		}]
	}
}